<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\YouTube;

class LiveChatGiftMembershipReceivedDetails extends \Google\Model
{
  /**
   * The ID of the membership gifting message that is related to this gift
   * membership. This ID will always refer to a message whose type is
   * 'membershipGiftingEvent'.
   *
   * @var string
   */
  public $associatedMembershipGiftingMessageId;
  /**
   * The ID of the user that made the membership gifting purchase. This matches
   * the `snippet.authorChannelId` of the associated membership gifting message.
   *
   * @var string
   */
  public $gifterChannelId;
  /**
   * The name of the Level at which the viewer is a member. This matches the
   * `snippet.membershipGiftingDetails.giftMembershipsLevelName` of the
   * associated membership gifting message. The Level names are defined by the
   * YouTube channel offering the Membership. In some situations this field
   * isn't filled.
   *
   * @var string
   */
  public $memberLevelName;

  /**
   * The ID of the membership gifting message that is related to this gift
   * membership. This ID will always refer to a message whose type is
   * 'membershipGiftingEvent'.
   *
   * @param string $associatedMembershipGiftingMessageId
   */
  public function setAssociatedMembershipGiftingMessageId($associatedMembershipGiftingMessageId)
  {
    $this->associatedMembershipGiftingMessageId = $associatedMembershipGiftingMessageId;
  }
  /**
   * @return string
   */
  public function getAssociatedMembershipGiftingMessageId()
  {
    return $this->associatedMembershipGiftingMessageId;
  }
  /**
   * The ID of the user that made the membership gifting purchase. This matches
   * the `snippet.authorChannelId` of the associated membership gifting message.
   *
   * @param string $gifterChannelId
   */
  public function setGifterChannelId($gifterChannelId)
  {
    $this->gifterChannelId = $gifterChannelId;
  }
  /**
   * @return string
   */
  public function getGifterChannelId()
  {
    return $this->gifterChannelId;
  }
  /**
   * The name of the Level at which the viewer is a member. This matches the
   * `snippet.membershipGiftingDetails.giftMembershipsLevelName` of the
   * associated membership gifting message. The Level names are defined by the
   * YouTube channel offering the Membership. In some situations this field
   * isn't filled.
   *
   * @param string $memberLevelName
   */
  public function setMemberLevelName($memberLevelName)
  {
    $this->memberLevelName = $memberLevelName;
  }
  /**
   * @return string
   */
  public function getMemberLevelName()
  {
    return $this->memberLevelName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LiveChatGiftMembershipReceivedDetails::class, 'Google_Service_YouTube_LiveChatGiftMembershipReceivedDetails');
