<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\YouTube;

class I18nLanguageSnippet extends \Google\Model
{
  /**
   * A short BCP-47 code that uniquely identifies a language.
   *
   * @var string
   */
  public $hl;
  /**
   * The human-readable name of the language in the language itself.
   *
   * @var string
   */
  public $name;

  /**
   * A short BCP-47 code that uniquely identifies a language.
   *
   * @param string $hl
   */
  public function setHl($hl)
  {
    $this->hl = $hl;
  }
  /**
   * @return string
   */
  public function getHl()
  {
    return $this->hl;
  }
  /**
   * The human-readable name of the language in the language itself.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(I18nLanguageSnippet::class, 'Google_Service_YouTube_I18nLanguageSnippet');
