<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ShoppingContent;

class RegionPostalCodeArea extends \Google\Collection
{
  protected $collection_key = 'postalCodes';
  protected $postalCodesType = RegionPostalCodeAreaPostalCodeRange::class;
  protected $postalCodesDataType = 'array';
  /**
   * Required. CLDR territory code or the country the postal code group applies
   * to.
   *
   * @var string
   */
  public $regionCode;

  /**
   * Required. A range of postal codes.
   *
   * @param RegionPostalCodeAreaPostalCodeRange[] $postalCodes
   */
  public function setPostalCodes($postalCodes)
  {
    $this->postalCodes = $postalCodes;
  }
  /**
   * @return RegionPostalCodeAreaPostalCodeRange[]
   */
  public function getPostalCodes()
  {
    return $this->postalCodes;
  }
  /**
   * Required. CLDR territory code or the country the postal code group applies
   * to.
   *
   * @param string $regionCode
   */
  public function setRegionCode($regionCode)
  {
    $this->regionCode = $regionCode;
  }
  /**
   * @return string
   */
  public function getRegionCode()
  {
    return $this->regionCode;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RegionPostalCodeArea::class, 'Google_Service_ShoppingContent_RegionPostalCodeArea');
