<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceUsage;

class DisableServiceResponse extends \Google\Model
{
  protected $serviceType = GoogleApiServiceusageV1Service::class;
  protected $serviceDataType = '';

  /**
   * The new state of the service after disabling.
   *
   * @param GoogleApiServiceusageV1Service $service
   */
  public function setService(GoogleApiServiceusageV1Service $service)
  {
    $this->service = $service;
  }
  /**
   * @return GoogleApiServiceusageV1Service
   */
  public function getService()
  {
    return $this->service;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DisableServiceResponse::class, 'Google_Service_ServiceUsage_DisableServiceResponse');
