<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SASPortalTesting;

class SasPortalMoveDeviceRequest extends \Google\Model
{
  /**
   * Required. The name of the new parent resource node or customer to reparent
   * the device under.
   *
   * @var string
   */
  public $destination;

  /**
   * Required. The name of the new parent resource node or customer to reparent
   * the device under.
   *
   * @param string $destination
   */
  public function setDestination($destination)
  {
    $this->destination = $destination;
  }
  /**
   * @return string
   */
  public function getDestination()
  {
    return $this->destination;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SasPortalMoveDeviceRequest::class, 'Google_Service_SASPortalTesting_SasPortalMoveDeviceRequest');
