<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Document;

class GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak extends \Google\Model
{
  /**
   * Unspecified break type.
   */
  public const TYPE_TYPE_UNSPECIFIED = 'TYPE_UNSPECIFIED';
  /**
   * A single whitespace.
   */
  public const TYPE_SPACE = 'SPACE';
  /**
   * A wider whitespace.
   */
  public const TYPE_WIDE_SPACE = 'WIDE_SPACE';
  /**
   * A hyphen that indicates that a token has been split across lines.
   */
  public const TYPE_HYPHEN = 'HYPHEN';
  /**
   * Detected break type.
   *
   * @var string
   */
  public $type;

  /**
   * Detected break type.
   *
   * Accepted values: TYPE_UNSPECIFIED, SPACE, WIDE_SPACE, HYPHEN
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak::class, 'Google_Service_Document_GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak');
