<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRun;

class GoogleCloudRunV2ListWorkerPoolsResponse extends \Google\Collection
{
  protected $collection_key = 'workerPools';
  /**
   * A token indicating there are more items than page_size. Use it in the next
   * ListWorkerPools request to continue.
   *
   * @var string
   */
  public $nextPageToken;
  protected $workerPoolsType = GoogleCloudRunV2WorkerPool::class;
  protected $workerPoolsDataType = 'array';

  /**
   * A token indicating there are more items than page_size. Use it in the next
   * ListWorkerPools request to continue.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * The resulting list of WorkerPools.
   *
   * @param GoogleCloudRunV2WorkerPool[] $workerPools
   */
  public function setWorkerPools($workerPools)
  {
    $this->workerPools = $workerPools;
  }
  /**
   * @return GoogleCloudRunV2WorkerPool[]
   */
  public function getWorkerPools()
  {
    return $this->workerPools;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudRunV2ListWorkerPoolsResponse::class, 'Google_Service_CloudRun_GoogleCloudRunV2ListWorkerPoolsResponse');
