<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class AppVersionRange extends \Google\Model
{
  /**
   * Highest app version in the range, inclusive.
   *
   * @var string
   */
  public $versionCodeEnd;
  /**
   * Lowest app version in the range, inclusive.
   *
   * @var string
   */
  public $versionCodeStart;

  /**
   * Highest app version in the range, inclusive.
   *
   * @param string $versionCodeEnd
   */
  public function setVersionCodeEnd($versionCodeEnd)
  {
    $this->versionCodeEnd = $versionCodeEnd;
  }
  /**
   * @return string
   */
  public function getVersionCodeEnd()
  {
    return $this->versionCodeEnd;
  }
  /**
   * Lowest app version in the range, inclusive.
   *
   * @param string $versionCodeStart
   */
  public function setVersionCodeStart($versionCodeStart)
  {
    $this->versionCodeStart = $versionCodeStart;
  }
  /**
   * @return string
   */
  public function getVersionCodeStart()
  {
    return $this->versionCodeStart;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AppVersionRange::class, 'Google_Service_AndroidPublisher_AppVersionRange');
