<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata extends \Google\Model
{
  protected $genericMetadataType = GoogleCloudAiplatformV1GenericOperationMetadata::class;
  protected $genericMetadataDataType = '';
  /**
   * The name of the Study that the Trial belongs to.
   *
   * @var string
   */
  public $study;
  /**
   * The Trial name.
   *
   * @var string
   */
  public $trial;

  /**
   * Operation metadata for suggesting Trials.
   *
   * @param GoogleCloudAiplatformV1GenericOperationMetadata $genericMetadata
   */
  public function setGenericMetadata(GoogleCloudAiplatformV1GenericOperationMetadata $genericMetadata)
  {
    $this->genericMetadata = $genericMetadata;
  }
  /**
   * @return GoogleCloudAiplatformV1GenericOperationMetadata
   */
  public function getGenericMetadata()
  {
    return $this->genericMetadata;
  }
  /**
   * The name of the Study that the Trial belongs to.
   *
   * @param string $study
   */
  public function setStudy($study)
  {
    $this->study = $study;
  }
  /**
   * @return string
   */
  public function getStudy()
  {
    return $this->study;
  }
  /**
   * The Trial name.
   *
   * @param string $trial
   */
  public function setTrial($trial)
  {
    $this->trial = $trial;
  }
  /**
   * @return string
   */
  public function getTrial()
  {
    return $this->trial;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata');
